/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4;

import com.mojang.brigadier.CommandDispatcher;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeRegistry;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import me.angel.challenges6t4.challenge.Challenges;
import me.angel.challenges6t4.command.ChallengeCommand;
import me.angel.challenges6t4.command.LastSwapCommand;
import me.angel.challenges6t4.command.SetPlayerNumberCommand;
import me.angel.challenges6t4.network.ChallengeNetworking;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Challenges6T4
implements ModInitializer,
DedicatedServerModInitializer {
    public static final String MOD_ID = "challenges6t4";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"challenges6t4");

    public void onInitialize() {
        LOGGER.info("Initializing Challenges6T4 Mod");
        Challenges.registerAll();
        LOGGER.info("Challenges6T4 Mod Initialized Successfully");
    }

    public void onInitializeServer() {
        LOGGER.info("Initializing Challenges6T4 Mod on Dedicated Server");
        ChallengeNetworking.registerNetworking();
        ServerPlayNetworking.registerGlobalReceiver(ChallengeNetworking.ChallengeUpdatePayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            LOGGER.info("Received challenge update from player: " + player.method_5477().getString() + " - Challenge: " + payload.challengeId() + ", Enabled: " + payload.enabled());
            if (player.method_64475(2)) {
                Challenge challenge = ChallengeRegistry.getChallenge(payload.challengeId());
                if (challenge != null) {
                    challenge.setEnabled(payload.enabled());
                    LOGGER.info("Updated challenge '" + challenge.getName().getString() + "' to " + (payload.enabled() ? "enabled" : "disabled") + " on server");
                    player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a[6T4] Challenge '" + challenge.getName().getString() + "' " + (payload.enabled() ? "enabled" : "disabled") + " and synced to all players.")), false);
                    ChallengeRegistry.syncToAllClientsFromServer(player);
                } else {
                    LOGGER.warn("Challenge not found: " + payload.challengeId());
                    player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c[6T4] Challenge not found: " + payload.challengeId())), false);
                }
            } else {
                LOGGER.info("Player " + player.method_5477().getString() + " attempted to change challenge without OP permissions");
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c[6T4] You need OP permissions to change challenge settings."), false);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(ChallengeNetworking.ChallengeOptionsUpdatePayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            LOGGER.info("Received options update from player: " + player.method_5477().getString() + " - Challenge: " + payload.challengeId() + ", Option: " + payload.optionKey() + ", Value: " + String.valueOf(payload.optionValue()));
            if (player.method_64475(2)) {
                Challenge challenge = ChallengeRegistry.getChallenge(payload.challengeId());
                if (challenge != null) {
                    Object value = payload.optionValue();
                    if (value instanceof Boolean) {
                        ChallengeSettings.setBooleanOption(payload.challengeId(), payload.optionKey(), (Boolean)value);
                    } else if (value instanceof Integer) {
                        ChallengeSettings.setIntOption(payload.challengeId(), payload.optionKey(), (Integer)value);
                    } else if (value instanceof Float) {
                        ChallengeSettings.setFloatOption(payload.challengeId(), payload.optionKey(), ((Float)value).floatValue());
                    } else if (value instanceof Long) {
                        ChallengeSettings.setLongOption(payload.challengeId(), payload.optionKey(), (Long)value);
                    } else if (value instanceof String) {
                        ChallengeSettings.setStringOption(payload.challengeId(), payload.optionKey(), (String)value);
                    }
                    LOGGER.info("Updated challenge option '" + payload.optionKey() + "' to '" + String.valueOf(value) + "' on server");
                    player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a[6T4] Challenge option '" + payload.optionKey() + "' updated to '" + String.valueOf(value) + "' and synced to all players.")), false);
                    ChallengeRegistry.syncToAllClientsFromServer(player);
                } else {
                    LOGGER.warn("Challenge not found: " + payload.challengeId());
                    player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c[6T4] Challenge not found: " + payload.challengeId())), false);
                }
            } else {
                LOGGER.info("Player " + player.method_5477().getString() + " attempted to change options without OP permissions");
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c[6T4] You need OP permissions to change challenge options."), false);
            }
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            LOGGER.info("Server starting - initializing server-side configuration");
            ChallengeSettings.setServer(server);
            ChallengeRegistry.setServer(server);
            ChallengeSettings.loadSettings();
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            LOGGER.info("Server started - marking as fully initialized");
            ChallengeRegistry.setServerFullyInitialized();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            LOGGER.info("Server stopping - saving server-side configuration");
            ChallengeSettings.saveSettings();
            ChallengeSettings.setServer(null);
            ChallengeRegistry.setServer(null);
            ChallengeRegistry.setServerFullyInitialized();
        });
        Challenges.registerAll();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LastSwapCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetPlayerNumberCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ChallengeCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
        });
        LOGGER.info("Challenges6T4 Mod Server Initialized Successfully");
    }
}

